% ======================================================================
% ASIGNACION 3 — P2 y P3 (corregido para calzar con el informe)
% P2: V* (min tiempo de ascenso) @ SL con CD0_real(M)=0.0142+ΔCD0(M)
% P3: M*_cruise (mínimo D) @ FL400 con la misma CD0_real(M)
% ======================================================================
clear; clc; close all;

%% ---------- Datos fijos (mismos que en la Asignación) ----------
S   = 992.8;              % ft^2
AR  = 7.51;
e   = 0.612;
k   = 1/(pi*AR*e);

W   = 79600;              % lbf (MTOW)
Tav = 30858;              % lbf (dos motores), usar este valor fijo en P2

% ISA fijas (NO calcular, usar las de la asignación)
rho0   = 2.377e-3;        % slug/ft^3  (S.L.)
aSL    = 1116.27;         % ft/s
rho40  = 5.85e-4;         % slug/ft^3  (FL400)
aFL400 = 967.9;           % ft/s

CD0_base = 0.0142;

% --- ΔCD0(M): Reemplaza con tus puntos EXACTOS ---
M_pts   = [0.67 0.68 0.74 0.79 0.80 0.82 0.83 0.84 0.845 0.85 0.86 0.865];
dCD_pts = [0.00135 0.00140 0.00175 0.00220 0.00220 0.00230 0.00235 0.00250 0.00300 0.00550 0.00770 0.00840];

% Rango de trabajo (mismo del informe)
Mmin = 0.67; Mmax = 0.85; M = linspace(Mmin, Mmax, 400);

% Interpolación sin extrapolar: clamp a los extremos
Mlo = M_pts(1); Mhi = M_pts(end);
Mclip = min(max(M, Mlo), Mhi);
dCD = interp1(M_pts, dCD_pts, Mclip, 'pchip');
CD0_real = CD0_base + dCD;

%% ====================== P2 — Mínimo tiempo (S.L.) ======================
V_SL = M .* aSL;
A_SL = 0.5 * rho0 * S .* CD0_real;
B_SL = (2 * k * W^2) / (rho0 * S);
D_SL = A_SL .* V_SL.^2 + B_SL ./ V_SL.^2;
Ps   = (Tav - D_SL) .* V_SL / W;

[Ps_max, i2] = max(Ps);
M_star_P2 = M(i2);
V_star_P2 = V_SL(i2);
Vkt_P2    = V_star_P2 / 1.687809857;

%% ====================== P3 — Crucero (FL400) ===========================
V_40 = M .* aFL400;
A_40 = 0.5 * rho40 * S .* CD0_real;
B_40 = (2 * k * W^2) / (rho40 * S);
D_40 = A_40 .* V_40.^2 + B_40 ./ V_40.^2;

[Dmin, i3] = min(D_40);
M_star_P3  = M(i3);
V_star_P3  = V_40(i3);
Vkt_P3     = V_star_P3 / 1.687809857;

%% --------------------- Salida controlada ---------------------
fprintf('--- ASIGNACION 3 (valores fijados como en el informe) ---\n');
fprintf('Constantes: rho0=%.6f, aSL=%.2f, rho40=%.6f, aFL400=%.1f, k=%.4f\n', ...
        rho0, aSL, rho40, aFL400, k);
fprintf('P2 (SL):  M* = %.3f,  V* = %.1f ft/s (%.1f kt),  Ps_max = %.1f ft/s\n', ...
        M_star_P2, V_star_P2, Vkt_P2, Ps_max);
fprintf('P3 (FL400): M*_cruise = %.3f,  V = %.1f ft/s (%.1f kt),  D_min = %.0f lbf\n', ...
        M_star_P3, V_star_P3, Vkt_P3, Dmin);

%% --------------------- Gráficas rápidas ---------------------
figure('Color','w','Name','Asignacion 3 - Verificación');
tiledlayout(2,2,'TileSpacing','compact','Padding','compact');

nexttile; plot(M, dCD, 'LineWidth',1.2); grid on;
xlabel('Mach'); ylabel('\Delta C_{D0}(M)'); title('\Delta C_{D0}(M) (pchip, clamped)');
xline(M_star_P2,'--','P2 M*'); xline(M_star_P3,'--','P3 M*');

nexttile; plot(M, CD0_real, 'LineWidth',1.2); grid on;
xlabel('Mach'); ylabel('C_{D0,real}(M)'); title('C_{D0,real}(M)=0.0142+\Delta C_{D0}(M)');

nexttile; plot(M, Ps, 'LineWidth',1.2); grid on;
xlabel('Mach'); ylabel('P_s (ft/s)'); title('P_s @ SL');
hold on; plot(M_star_P2, Ps_max, 'o','MarkerSize',6,'LineWidth',1.2);

nexttile; plot(M, D_40, 'LineWidth',1.2); grid on;
xlabel('Mach'); ylabel('D @ FL400 (lbf)'); title('D(M) @ FL400');
hold on; plot(M_star_P3, Dmin, 's','MarkerSize',6,'LineWidth',1.2);
